<?php
$success = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = $_POST['name'] ?? '';
    $email = $_POST['email'] ?? '';
    $subject = $_POST['subject'] ?? '';
    $message = $_POST['message'] ?? '';
    
    if (!empty($name) && !empty($email) && !empty($subject) && !empty($message)) {
        // هنا يمكن إضافة كود لإرسال البريد الإلكتروني أو حفظ الرسالة في قاعدة البيانات
        $success = "تم إرسال رسالتك بنجاح! سنتواصل معك قريباً.";
        $name = $email = $subject = $message = '';
    } else {
        $error = "يرجى ملء جميع الحقول";
    }
}
?>

<?php if ($success): ?>
    <div class="success-message"><?php echo $success; ?></div>
<?php endif; ?>

<?php if ($error): ?>
    <div class="error-message"><?php echo $error; ?></div>
<?php endif; ?>

<div style="display: grid; grid-template-columns: 1fr 1fr; gap: 30px;">
    <!-- نموذج الاتصال -->
    <div class="table-container">
        <h2 style="margin-bottom: 20px; color: #2c3e50;">أرسل رسالة</h2>
        
        <form method="POST" action="">
            <div class="form-group">
                <label for="name">الاسم *</label>
                <input type="text" id="name" name="name" required 
                       value="<?php echo htmlspecialchars($name ?? ''); ?>">
            </div>
            
            <div class="form-group">
                <label for="email">البريد الإلكتروني *</label>
                <input type="email" id="email" name="email" required 
                       value="<?php echo htmlspecialchars($email ?? ''); ?>">
            </div>
            
            <div class="form-group">
                <label for="subject">الموضوع *</label>
                <input type="text" id="subject" name="subject" required 
                       value="<?php echo htmlspecialchars($subject ?? ''); ?>">
            </div>
            
            <div class="form-group">
                <label for="message">الرسالة *</label>
                <textarea id="message" name="message" rows="6" required 
                          style="resize: vertical;"><?php echo htmlspecialchars($message ?? ''); ?></textarea>
            </div>
            
            <button type="submit" class="btn btn-primary">إرسال الرسالة</button>
        </form>
    </div>
    
    <!-- معلومات الاتصال -->
    <div>
        <div class="table-container" style="margin-bottom: 20px;">
            <h2 style="margin-bottom: 20px; color: #2c3e50;">معلومات الاتصال</h2>
            
            <div style="line-height: 2.5;">
                <p style="display: flex; align-items: center;">
                    <span style="font-size: 24px; margin-left: 15px;">📍</span>
                    <strong>العنوان:</strong> الرياض، المملكة العربية السعودية
                </p>
                
                <p style="display: flex; align-items: center;">
                    <span style="font-size: 24px; margin-left: 15px;">📞</span>
                    <strong>الهاتف:</strong> +966 50 123 4567
                </p>
                
                <p style="display: flex; align-items: center;">
                    <span style="font-size: 24px; margin-left: 15px;">📧</span>
                    <strong>البريد:</strong> info@carrental.com
                </p>
                
                <p style="display: flex; align-items: center;">
                    <span style="font-size: 24px; margin-left: 15px;">🕐</span>
                    <strong>ساعات العمل:</strong> 8 صباحاً - 10 مساءً (يومياً)
                </p>
            </div>
        </div>
        
        <div class="table-container">
            <h2 style="margin-bottom: 20px; color: #2c3e50;">تابعنا على</h2>
            
            <div style="display: flex; gap: 15px; flex-wrap: wrap;">
                <a href="#" class="btn btn-primary" style="flex: 1; min-width: 120px; text-align: center;">
                    Facebook
                </a>
                <a href="#" class="btn btn-primary" style="flex: 1; min-width: 120px; text-align: center;">
                    Twitter
                </a>
                <a href="#" class="btn btn-primary" style="flex: 1; min-width: 120px; text-align: center;">
                    Instagram
                </a>
                <a href="#" class="btn btn-primary" style="flex: 1; min-width: 120px; text-align: center;">
                    WhatsApp
                </a>
            </div>
        </div>
        
        <div class="table-container" style="margin-top: 20px;">
            <h2 style="margin-bottom: 15px; color: #2c3e50;">الأسئلة الشائعة</h2>
            
            <div style="line-height: 1.8;">
                <p><strong>س: كيف يمكنني حجز سيارة؟</strong></p>
                <p style="margin-bottom: 15px; color: #555;">
                    يمكنك حجز سيارة من خلال قسم الحجوزات في لوحة التحكم، 
                    حيث تختار السيارة المتاحة وتحدد فترة الحجز.
                </p>
                
                <p><strong>س: ما هي طرق الدفع المتاحة؟</strong></p>
                <p style="margin-bottom: 15px; color: #555;">
                    نقبل الدفع نقداً، بطاقات الائتمان، والتحويل البنكي.
                </p>
                
                <p><strong>س: هل يمكنني إلغاء الحجز؟</strong></p>
                <p style="color: #555;">
                    نعم، يمكنك إلغاء الحجز قبل 24 ساعة من موعد الاستلام 
                    دون أي رسوم إضافية.
                </p>
            </div>
        </div>
    </div>
</div>